<?php
/**
 * SISTEMA DE LOGIN RESILIENTE V5.2 - TMDB ANIMATED EDITION
 */

error_reporting(0);
ini_set('display_errors', 0);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

/**
 * Função de Carregamento Ultra-Resiliente
 */
function loadSecureConfig($path, $default = []) {
    try {
        if (!file_exists($path) || !is_readable($path)) return $default;
        $content = @file_get_contents($path);
        if ($content === false || empty($content)) return $default;
        $data = json_decode($content, true);
        if (json_last_error() !== JSON_ERROR_NONE || !is_array($data)) return $default;
        return $data;
    } catch (Exception $e) {
        return $default;
    }
}

/**
 * Sistema Dinâmico TMDB API com Blindagem
 */
function getTmdbPosters() {
    $apiKey = "95497bb6942dfa426d495f9350f011b9"; // Chave pública trending
    $url = "https://api.themoviedb.org/3/trending/movie/week?api_key=" . $apiKey;
    
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 4,
        CURLOPT_SSL_VERIFYPEER => false
    ]);
    
    $result = curl_exec($ch);
    curl_close($ch);
    
    $data = json_decode($result, true);
    $posters = [];
    
    if (isset($data['results']) && is_array($data['results'])) {
        foreach (array_slice($data['results'], 0, 24) as $movie) {
            if (!empty($movie['poster_path'])) {
                $posters[] = $movie['poster_path'];
            }
        }
    }
    
    // Fallback caso a API falhe
    return !empty($posters) ? $posters : ['/uDsv99yI78vSbe9IQhL2vbjS78D.jpg', '/kdSUEp7S7Es9mbj9N99of69pBsH.jpg'];
}

$config = loadSecureConfig('config.json', ['logo' => 'img/logo.png']);
$dns_data = loadSecureConfig("./includes/dns/dns.json", []);
$movies = getTmdbPosters();
$available_servers = [];

if (!empty($dns_data)) {
    for ($i = 1; $i <= 10; $i++) {
        $srvKey = "server{$i}";
        $nmKey = "server{$i}_name";
        if (!empty($dns_data[$srvKey]) && !empty($dns_data[$nmKey])) {
            $available_servers[] = [
                'name' => trim($dns_data[$nmKey]),
                'url' => rtrim(trim($dns_data[$srvKey]), '/')
            ];
        }
    }
}

// Processamento do Login (AJAX POST) - Atualizado para suporte a Portas (8080, etc)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["username"])) {
    header('Content-Type: application/json');
    $username = trim($_POST["username"] ?? '');
    $password = trim($_POST["password"] ?? '');
    
    if (empty($username) || empty($password)) {
        echo json_encode(['success' => false, 'message' => 'Campos obrigatórios vazios.']);
        exit;
    }

    if (empty($available_servers)) {
        echo json_encode(['success' => false, 'message' => 'Erro: DNS offline.']);
        exit;
    }

    $last_error = 'Credenciais incorretas.';
    
    foreach ($available_servers as $server) {
        // Garante que a URL do servidor seja processada corretamente
        $baseUrl = rtrim($server['url'], '/');
        $authUrl = $baseUrl . "/player_api.php?username=" . urlencode($username) . "&password=" . urlencode($password);
        
        $ch = curl_init();
        
        // Configurações para aceitar portas customizadas e conexões resilientes
        curl_setopt_array($ch, [
            CURLOPT_URL => $authUrl,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_IPRESOLVE => CURL_IPRESOLVE_V4,
            CURLOPT_TIMEOUT => 10,           // Aumentado para dar tempo em portas lentas
            CURLOPT_CONNECTTIMEOUT => 5,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_USERAGENT => 'Resilient_Turbo_V4',
            CURLOPT_FOLLOWLOCATION => true,  // Segue redirecionamentos se houver
            CURLOPT_PORT => parse_url($baseUrl, PHP_URL_PORT) ?: null // Detecta a porta automaticamente (ex: 8080)
        ]);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $curl_error = curl_error($ch);
        curl_close($ch);

        if ($http_code == 200 && !empty($response)) {
            $api = json_decode($response, true);
            if (is_array($api) && isset($api['user_info'])) {
                if ((int)$api['user_info']['auth'] === 1) {
                    $status = $api['user_info']['status'] ?? '';
                    if ($status === "Active") {
                        $_SESSION["username"] = $username;
                        $_SESSION["password"] = $password;
                        $_SESSION["server_url"] = $baseUrl; 
                        $_SESSION["server_name"] = $server['name'];
                        $_SESSION["exp_date"] = $api['user_info']['exp_date'] ?? 'N/A';
                        $_SESSION["is_logged"] = true;
                        echo json_encode(['success' => true, 'redirect' => 'homex.php']);
                        exit;
                    } else {
                        $last_error = 'Conta ' . ($status ?: 'Inativa') . '.';
                        break; 
                    }
                }
            }
        } else {
            // Caso falhe a conexão física com o servidor/porta
            $last_error = "Servidor " . $server['name'] . " inacessível ou porta bloqueada.";
        }
    }
    echo json_encode(['success' => false, 'message' => $last_error]);
    exit;
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1.0, user-scalable=no">
    <title>WEB PLAYER</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root { --accent: #E50914; --bg: #000; --input: #333; --text: #fff; }
        * { box-sizing: border-box; outline: none !important; user-select: none; }
        
        body, html { 
            margin: 0; padding: 0; width: 100%; height: 100%;
            background-color: var(--bg); font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: var(--text); overflow: hidden;
            display: flex; align-items: center; justify-content: center;
        }

        /* Background Dinâmico TMDB */
        .bg-container { position: fixed; inset: 0; z-index: 1; background: radial-gradient(circle, transparent 10%, black 90%), #141414; }
        .movie-overlay { 
            position: absolute; inset: 0; display: grid; 
            grid-template-columns: repeat(auto-fill, minmax(180px, 1fr)); 
            gap: 10px; padding: 10px; opacity: 0.18; 
            filter: grayscale(100%) contrast(1.1); pointer-events: none; 
        }

        /* Animação Sequencial de Posters */
        .movie-overlay img { 
            width: 100%; border-radius: 4px; 
            opacity: 0; transform: translateY(20px);
            animation: fadeInGrid 0.8s ease forwards;
        }

        @keyframes fadeInGrid {
            to { opacity: 1; transform: translateY(0); }
        }

        /* Card de Login Animado */
        .login-card { 
            position: relative; z-index: 10; background: rgba(0, 0, 0, 0.78); 
            border-radius: 8px; padding: 50px 45px; 
            width: 90%; max-width: 400px; 
            box-shadow: 0 20px 50px rgba(0,0,0,0.9);
            animation: cardEntrance 0.7s cubic-bezier(0.2, 0.8, 0.2, 1);
        }

        @keyframes cardEntrance {
            from { opacity: 0; transform: scale(0.9) translateY(30px); }
            to { opacity: 1; transform: scale(1) translateY(0); }
        }

        .brand-logo img { max-width: 160px; margin: 0 auto 35px; display: block; filter: drop-shadow(0 4px 8px rgba(0,0,0,0.5)); }
        
        .input-wrapper { position: relative; margin-bottom: 20px; width: 100%; }
        .input-field { 
            width: 100%; padding: 16px 20px; background: var(--input); 
            border: none; border-radius: 4px; color: #fff; font-size: 16px; transition: 0.3s;
        }
        .input-field:focus { background: #454545; box-shadow: inset 0 -2px 0 #e87c03; }

        .btn-login { 
            width: 100%; padding: 16px; background: var(--accent); 
            border: none; border-radius: 4px; color: white; font-weight: 700; 
            font-size: 16px; margin-top: 10px; cursor: pointer; transition: 0.2s; 
        }
        .btn-login:hover { background: #f40612; transform: translateY(-1px); }
        .btn-login:active { transform: translateY(1px); }

        .error-message { background: #e87c03; color: white; padding: 12px; border-radius: 4px; margin-top: 20px; display: none; font-size: 14px; text-align: center; }

        /* Tela de Perfil Animada */
        .profile-card { position: absolute; z-index: 11; display: none; opacity: 0; text-align: center; width: 100%; transition: 0.6s cubic-bezier(0.4, 0, 0.2, 1); }
        .profile-title { font-size: clamp(2rem, 6vw, 3.5rem); font-weight: 500; margin-bottom: 40px; letter-spacing: -1px; }

        .profile-avatar-box { 
            width: 160px; height: 160px; 
            border-radius: 4px; margin: 0 auto 15px; 
            border: 3.5px solid transparent; overflow: hidden; cursor: pointer;
            transition: 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .profile-avatar-box img { width: 100%; height: 100%; object-fit: cover; }
        .profile-avatar-box:hover { border-color: #fff; transform: scale(1.1); }
        .profile-name { color: #808080; font-size: 1.4rem; margin: 0; transition: 0.3s; }
        .profile-avatar-box:hover + .profile-name { color: #fff; }

        @media (max-width: 480px) {
            .login-card { padding: 40px 25px; background: #000; }
            .bg-container { background: #000; }
        }
    </style>
</head>
<body oncontextmenu="return false;">

    <div class="bg-container">
        <div class="movie-overlay">
            <?php if (isset($movies) && is_array($movies)): 
                $delay = 0;
                foreach ($movies as $path): 
                $delay += 0.05;
            ?>
                <img src="https://image.tmdb.org/t/p/w300<?= htmlspecialchars($path) ?>" 
                     style="animation-delay: <?= $delay ?>s"
                     onerror="this.style.display='none'"> 
            <?php endforeach; endif; ?>
        </div>
    </div>

    <main class="login-card" id="login-step">
        <div class="brand-logo">
            <img src="<?= htmlspecialchars($config['logo']); ?>" alt="Logo">
        </div>
        <form id="login-form">
            <div class="input-wrapper">
                <input type="text" class="input-field" placeholder="E-mail ou usuário" name="username" required autocomplete="off">
            </div>
            <div class="input-wrapper">
                <input type="password" class="input-field" placeholder="Senha" name="password" required autocomplete="off">
            </div>
            <button type="submit" class="btn-login" id="btn-action">Entrar</button>
            <div class="error-message" id="error-box"></div>
        </form>
    </main>

    <main class="profile-card" id="profile-step">
        <h1 class="profile-title">Quem está assistindo?</h1>
        <div style="display: inline-block;" onclick="finishLogin()">
            <div class="profile-avatar-box">
                <img src="https://upload.wikimedia.org/wikipedia/commons/0/0b/Netflix-avatar.png" alt="Avatar">
            </div>
            <p class="profile-name" id="display-user">USUÁRIO</p>
        </div>
    </main>

    <script>
    let finalRedirectUrl = '';

    document.getElementById('login-form').addEventListener('submit', async function(e) {
        e.preventDefault();
        const btn = document.getElementById('btn-action');
        const errorBox = document.getElementById('error-box');
        
        btn.disabled = true;
        btn.innerHTML = '<i class="fa-solid fa-circle-notch fa-spin"></i> Aguarde...';
        errorBox.style.display = 'none';

        try {
            const formData = new FormData(this);
            const response = await fetch(window.location.href, { method: 'POST', body: formData });
            const data = await response.json();

            if (data.success) {
                finalRedirectUrl = data.redirect;
                document.getElementById('display-user').innerText = this.username.value.toUpperCase();
                
                const loginCard = document.getElementById('login-step');
                const profileStep = document.getElementById('profile-step');
                
                // Animação de Saída do Login
                loginCard.style.opacity = '0';
                loginCard.style.transform = 'scale(1.1) translateY(-20px)';
                
                setTimeout(() => {
                    loginCard.style.display = 'none';
                    profileStep.style.display = 'block';
                    setTimeout(() => { 
                        profileStep.style.opacity = '1';
                        profileStep.style.transform = 'translateY(0)';
                    }, 50);
                }, 600);
            } else {
                errorBox.textContent = data.message;
                errorBox.style.display = 'block';
                btn.disabled = false;
                btn.innerText = 'Entrar';
            }
        } catch (err) {
            errorBox.textContent = 'Falha na conexão.';
            errorBox.style.display = 'block';
            btn.disabled = false;
            btn.innerText = 'Entrar';
        }
    });

    function finishLogin() {
        if(finalRedirectUrl) {
            document.body.style.transition = 'opacity 1s cubic-bezier(0.4, 0, 0.2, 1)';
            document.body.style.opacity = '0';
            setTimeout(() => { window.location.replace(finalRedirectUrl); }, 900);
        }
    }
    </script>
</body>
</html>